import matplotlib.pyplot as plt
import pandas as pd
from PIL import Image


def plot_episode_stats(stats, smoothing_window=10, noshow=False):
    fig, axes = plt.subplots(1, 2, figsize=(10, 5), tight_layout=True)

    # Plot the episode length over time
    ax = axes[0]
    ax.plot(stats.episode_lengths)
    ax.set_xlabel("Episode")
    ax.set_ylabel("Episode Length")
    ax.set_title("Episode Length over Time")

    # Plot the episode reward over time
    ax = axes[1]
    rewards_smoothed = pd.Series(stats.episode_rewards).rolling(smoothing_window, min_periods=smoothing_window).mean()
    ax.plot(rewards_smoothed)
    ax.set_xlabel("Episode")
    ax.set_ylabel("Episode Reward (Smoothed)")
    ax.set_title("Episode Reward over Time\n(Smoothed over window size {})".format(smoothing_window))


def save_rgb_animation(rgb_arrays, filename, duration=500):
    """
    Save an animated GIF from a list of RGB arrays.

    Parameters:
        rgb_arrays (list of numpy arrays): List of RGB arrays (numpy arrays).
        filename (str): The name of the output GIF file.
        duration (int): Duration (in milliseconds) for each frame (default is 500).
    """
    # Create a list to hold each frame
    frames = []

    # Convert RGB arrays to PIL Image objects
    for rgb_array in rgb_arrays:
        img = Image.fromarray(rgb_array)
        frames.append(img)

    # Save the frames as an animated GIF
    frames[0].save(filename, save_all=True, append_images=frames[1:], duration=duration, loop=0)
