import pylab as pl

from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from mpl_toolkits.axes_grid1.inset_locator import mark_inset

def plot_glucose(t, xdata, udata):

    pl.close("all")

    pl.rc('text', usetex=True)
    pl.locator_params(nbins=4)

    pgf_with_rc_fonts = {
        "font.family": "serif",
        "font.serif": [],                   # use latex default serif font
        "font.sans-serif": ["DejaVu Sans"], # use a specific sans-serif font
    }
    pl.rcParams.update(pgf_with_rc_fonts)

    fig = pl.figure()

    # Plot states

    ax1 = pl.subplot(211)
    pl.plot(t, xdata[:,0], label = "$G$")
    pl.plot(t, xdata[:,1], label = "$X$")
    pl.plot(t, xdata[:,2], label = "$I$")
    pl.plot(t, xdata[:,3], label = "$D$")
    pl.setp(ax1.get_xticklabels(), visible = False)

    # Set axis and legend

    pl.ylabel("$x$", rotation = 0, ha = "right")
    pl.legend(loc = "upper right")

    # Plot controls

    ax2 = pl.subplot(212, sharex = ax1)
    pl.step(t[:-1], udata[:, 0], where = "post", label = r"$u_{\mathrm{icr}}$")
    pl.step(t[:-1], udata[:, 1], where = "post", label = r"$u_{\mathrm{meal}}$")

    ax2.set_ylim(ax2.get_ylim()[0]-0.5, ax2.get_ylim()[1]+0.5)

    # Set axis and legend

    pl.xlabel("$t$")
    pl.ylabel("$u$", rotation = 0, ha = "right")
    pl.legend(loc = "upper right")

    # Insert detail view

    axins = inset_axes(ax2, 3.0, 1.4, loc=9, borderpad = 0.8)  # zoom = 6
    axins.step(t[:-1], udata[:, 0], where = "post", label = r"$u_{\mathrm{icr}}$")
    axins.step(t[:-1], udata[:, 1], where = "post", label = r"$u_{\mathrm{meal}}$")

    x1, x2, y1, y2 = 0.0, 8.0, ax2.get_ylim()[0], ax2.get_ylim()[1]
    axins.set_xlim(x1, x2)
    axins.set_ylim(y1, y2)

    axins.yaxis.tick_right()

    pl.xlabel("$t$")
    pl.ylabel("$u$", rotation = 0, ha = "right")

    mark_inset(ax2, axins, loc1=2, loc2=3, fc="none", ec="0.5", ls="dashed")

    # Show plot

    fig.tight_layout()
    pl.show()
    # pl.savefig("/tmp/plot.eps", bbox_inches="tight", format = "eps")
