function plot_glucose(T, x_opt, u_opt, u_icr_opt)

    import casadi.*
    
    ax1 = subplot(2,1,1);
    hold on;
    
    plot(T, x_opt(:,1))
    plot(T, x_opt(:,2))
    plot(T, x_opt(:,3))
    plot(T, x_opt(:,4))
    
    legend('G', 'X', 'I', 'D');
    
    xlabel('t (s)');
    ylabel('x');
    
    ax2 = subplot(2,1,2);
    hold on;
    
    plot(T(1:end-1), u_opt)
    plot(T(1:end-1), u_icr_opt)
    
    legend('u_{opt}', 'u_{icr}');
    
    xlabel('t (s)');
    ylabel('u');
    
end