import numpy as np
import matplotlib.pylab as plt
import matplotlib.animation as animation
import casadi as ca
from rk4 import rk4
from plot_helper import animate_pendulum
plt.close("all")

# parameters
T = 30                  # time length
N = 150                 # number of discrete time points
h = T/N                 # one discrete time step
nx = 2                  # state dimension
nu = 1                  # control dimension

x0bar = [np.pi, 0]      # initial state
xNbar = [0, 0]          # target state

# set up dynamics
# casadi variables independent of the later declared Opti() instance
x = ca.SX.sym('x', nx)      # general state
u = ca.SX.sym('u', nu)      # general control
# declare names for convenience
theta = x[0]
omega = x[1]

# ode of dynamics
xdot = ca.vertcat(omega, ca.sin(theta) + u)
# Declare casadi function for ode
f = ca.Function('f', [x, u], [xdot])
# Declare casadi function for integration
# This function can then be called like a normal function as F(x, u)
# if x_k, u_k is the input, x_k+1 will be the output
F = ca.Function('F', [x, u], [rk4(f, x, u, h)])

# define NLP
opti = ca.Opti()
X = opti.variable(nx, N+1)      # X[:,k] is state at discrete time k
U = opti.variable(nu, N)        # U[:,k] is control at discrete time k

# TODO: define objective

# TODO: define constraints

# initialize all states at x0bar
opti.set_initial(X, ca.repmat(x0bar, 1, N+1) )

# TODO: solve with IPOPT

# TODO: plot trajectories

# animate swing up
# Theta_opt should contain the optimal trajectory of theta
ani = animate_pendulum(Theta_opt)