import matplotlib.pylab as plt
import casadi as ca
from plot_helper import plot_plate
plt.close("all")

a = 10.0                            # size of plate
n = 5                               # number of circles
opti = ca.Opti()

# decision variables
x = opti.variable(n)                # x positions of the circles
y = opti.variable(n)                # y positions of the circles
R = opti.variable()                 # radius of the small circles

# for convenience
r = ca.vertcat(R, R, R, 2*R, 2*R)   # radius of each circle

# TODO: objective

# TODO: constraints

# choose initial guess of the decision variables
x_init = [2, 9, 4, 6, 8]
y_init = [2, 5, 8, 3, 8] 
R_init = 1

# pass initial guess to casadi
opti.set_initial(x, x_init)
opti.set_initial(y, y_init)
opti.set_initial(R, R_init)

# set IPOPT as solver
opti.solver('ipopt')
# actually solve the problem
sol = opti.solve()

# read optimal values
x_opt = sol.value(x)
y_opt = sol.value(y)
R_opt = sol.value(R)
r_opt = sol.value(r)

# visualize initial guess
r_init = opti.value(r, [R==R_init])         # evaluate r for R = R_init
plot_plate(x_init, y_init, r_init, a)
plt.title('initial guess')

# visualize solution
plot_plate(x_opt, y_opt, r_opt, a)
plt.title('solution')

print("R at solution:", R_opt)