import numpy as np
from scipy.linalg import solve_discrete_are

from utils import ode, RK4_integrator


def LQR_design(Q, R, Ts, nSteps):
    # linearize at x_lin, u_lin
    x_lin = np.vstack((0, 0))
    u_lin = 0
    _, A, B = RK4_integrator(x_lin, u_lin, Ts, nSteps, ode, compute_sensitivities=True)

    # solve the ricatti problem
    P = solve_discrete_are(A, B, Q, R)
    K = np.linalg.solve((B.T @ P @ B + R), B.T @ P @ A)
    return (K, P)
