import numpy as np

def back_AD(u, m, x0, h):
    N = len(u)

    # initialize bar quantities
    ubar = np.zeros(N)
    xbar = np.zeros(N)
    xbar[m] = 1

    # forward sweep
    X = np.zeros(N)
    X[0] = x0
    for i in range(N-1):
        X[i+1] = X[i] + h * ((1 - X[i]) * X[i] + u[i])

    # backward sweep
    for i in range(N-1, 0, -1):
        dfdu = h
        dfdx = 1 + h * (1 - 2 * X[i])
        ubar[i] = ubar[i] + xbar[i] * dfdu
        xbar[i-1] = xbar[i-1] + xbar[i] * dfdx 

    # x1 = f(x0,u)
    ubar[0] = ubar[0] + xbar[0] * h

    # mth row of jacobian
    lamJ = ubar.T
    return lamJ
