import numpy as np
import matplotlib.pylab as plt
import matplotlib.animation as animation

def animate_pendulum(Theta, dt=0.03):
    '''
    Create animation of a pendulum, where Theta contains the trajectory of its
    angle. dt defines the time gap (in seconds) between two succesive entries.

    Theta should be a list or 1D-numpy array
    '''
    fig = plt.figure()
    ax = fig.add_subplot(111, autoscale_on=False, xlim=(-1.2, 1.2), ylim=(-1.2, 1.2))
    ax.set_aspect('equal')
    ax.axis('off')

    # create empty plot
    line, = ax.plot([], [], 'o-', lw=2)

    def init():
        # placeholder for data
        line.set_data([], [])
        return line,

    def animate(i):
        # plot pendulum as defined by i-th entry of Theta
        thisx = [0, -np.sin(Theta[i])]
        thisy = [0, np.cos(Theta[i])]
        line.set_data(thisx, thisy)
        return line,

    ani = animation.FuncAnimation(fig, animate, Theta.size,
                                  interval=dt*1000, repeat_delay=500,
                                  blit=True, init_func=init)
    return ani