import casadi as ca


def sqrt(x):
    return x**(1/2)


def ode(x):

    # parameters
    d1 = 0.1
    d2 = 0.5
    g = 9.81
    w = 1
    M = 1

    # x_dot = f(x)
    dx = [
        x[2],
        x[3],
        -(x[2]-w)*sqrt((x[2]-w)**2 + x[3]**2)*d1,
        -x[3]*sqrt((x[2]-w)**2 + x[3]**2)*d1 - g,
        x[6],
        x[7],
        -(x[6]-w)*sqrt((x[6]-w)**2 + x[7]**2)*d2,
        -x[7]*sqrt((x[6]-w)**2 + x[7]**2)*d2- g,
    ]
    return ca.vertcat(*dx)
