import casadi as ca

from ode import ode
from rk4step import rk4step


def ballistic_dynamics_RK4( v_start ):

    T = 0.5
    M = 100
    DT = T/M

    X0 = ca.vertcat(0, 0, v_start[0], v_start[1], 10, 0, v_start[2], v_start[3])

    # RK4 integrator
    Xf = X0
    for j in range(M):
        Xf = rk4step(lambda t,x: ode(x), DT, Xf, 0)

    P_t = ca.vertcat(Xf[0], Xf[1], Xf[4], Xf[5])
    return P_t
