import numpy as np


def newton_type(w0, F, M, numit):
    """implementation of a Newton type algorithm for finding the root of
    function F(w), i.e., finding w such that F(w) = 0

    Inputs:   w0:     initial guess (column vector)
            F:      function handle of F
            M:      function handle of a approximation of the Jacobian of F
            numit:  number of iterations performed

    Returns:
            W:      iteration history of w
    """
    W = np.empty((w0.size, numit+1))
    W[:, 0] = w0

    for k in range(numit):
        w = W[:,k]
        W[:,k+1] = w - np.linalg.solve(M(w), F(w))  # Newton-type step

    return W
