import casadi as ca
 
# Create NLP: Solve the Rosenbrock problem (constrained):
#     minimize    (1-x)^2 + 100*z^2
#     subject to  z + x^2 - y == 0

x = ca.SX.sym('x')
y = ca.SX.sym('y')
z = ca.SX.sym('z')
v = ca.vertcat(x, y, z)
f = (1-x)**2 + 100*z**2
g = z - (y - x**2)
nlp = {'x': v, 'f': f, 'g': g}

# Create IPOPT solver object
solver = ca.nlpsol('solver', 'ipopt', nlp)

# Solve the NLP
res = solver(
    x0 = [2.5, 3.0, 0.75],  # solution guess
    lbx = -ca.inf,          # lower bound on x
    ubx = ca.inf,           # upper bound on x
    lbg = 0,                # lower bound on g
    ubg = 0,                # upper bound on g
)

# Print the solution
f_opt = res["f"].full()
print(f"f={f_opt}")
x_opt = res["x"].full()
print(f"x={x_opt}")
lam_x_opt = res["lam_x"].full()
print(f"lam_x={lam_x_opt}")
lam_g_opt = res["lam_g"].full()
print(f"lam_g={lam_g_opt}")
