import casadi as ca
import matplotlib.pyplot as plt
import numpy as np

from ballistic_dynamics_RK4 import ballistic_dynamics_RK4
from ode import ode


# for people who cannot see an interactive plot, uncomment the following lines
# import matplotlib
# if matplotlib.get_backend() == 'agg':
#     matplotlib.use('WebAgg')
# print(f'backend: {matplotlib.get_backend()}')


# parameters
vbar = 15             # max velocity
w0 = np.zeros((4,1))  # initial guess

# decision variables
# TODO

# objective
# TODO


# constraints
g = []
lbg = []
ubg = []

# p1z >= 0
# TODO

# p2z >= 0
# TODO

# v1^2 <= vbar^2
# TODO

# v2^2 <= vbar^2
# TODO

nlp = {'x': w, 'f': f, 'g': ca.vertcat(*g)}

# Create IPOPT solver object
solver = ca.nlpsol('solver', 'ipopt', nlp)

# Solve the NLP
res = solver(
    # TODO: fill in the correct parameters (replace "...")
    x0=...,        # solution guess
    lbx=...,       # lower bound on x
    ubx=...,       # upper bound on x
    lbg=...,       # lower bound on g
    ubg=...,       # upper bound on g
)


# simulate optimal solution
wsol = res["x"].full().flatten()
T = 0.5
M = 100
DT = T/M
X0 = np.array([0, 0, wsol[0], wsol[1], 10, 0, wsol[2], wsol[3]])
X = np.zeros((X0.size, M+1))
X[:, 0] = X0

# TODO: simulate with one step RK4 integrator



plt.figure(1)
plt.plot(X[0,:], X[1,:], label=r'$p_1$')
plt.plot(X[4,:], X[5,:], label=r'$p_2$')
plt.legend()

plt.show()
