import casadi as ca
from matplotlib import pyplot as plt
import numpy as np

from rk4step import rk4step


# for people who cannot see an interactive plot, uncomment the following lines
import matplotlib
if matplotlib.get_backend() == 'agg':
    matplotlib.use('WebAgg')
print(f'backend: {matplotlib.get_backend()}')


rho = 28
sigma = 10
beta = 8/3

def ode(x): 
    return ca.vertcat(
    sigma * (x[1] - x[0]),
    x[0] * (rho - x[2]) - x[1],
    x[0] * x[1] - beta * x[2],
)


x0 = np.array([1, 0, 0])
h = .01
t_max = 100
N = int(t_max/h)
t = np.linspace(0, t_max, N)

X = np.zeros((x0.size, N))
X[:,0] = x0
for k in range(1,len(t)):
    X[:,k] = rk4step(ode, h, X[:,k-1]).full().flatten()


fig, ax = plt.subplots(subplot_kw={'projection': '3d'})
ax.plot(X[0,:], X[1,:], X[2,:])
plt.show()
