import numpy as np
import nosnoc
from cart_pole_with_friction import get_cart_pole_model_and_ocp
from pendulum_utils import plot_results

def solve_example():
    x_ref = np.array([0, 180 / 180 * np.pi, 0, 0])  # end upwards

    # opts
    opts = nosnoc.NosnocOpts()
    opts.irk_scheme = nosnoc.IrkSchemes.RADAU_IIA
    opts.n_s = 2
    opts.print_level = 1
    # opts.step_equilibration = nosnoc.StepEquilibrationMode.HEURISTIC_DELTA

    raise NotImplementedError('TODO: specify discretization options below.')
    # opts.N_stages =  # number of control intervals
    # opts.N_finite_elements =   # number of finite element on every control intevral
    # opts.terminal_time =  # Time horizon

    model, ocp = get_cart_pole_model_and_ocp()

    ## Solve OCP
    solver = nosnoc.NosnocSolver(opts, model, ocp)
    # solver.problem.print()
    results = solver.solve()

    distance_to_target = np.abs(x_ref-results['x_traj'][-1])
    print(f"{distance_to_target=}")

    return results

def main():
    results = solve_example()
    plot_results(results)


if __name__ == "__main__":
    main()
