import casadi as ca
import numpy as np
from nosnoc import casadi_length, NosnocOcp, NosnocAutoModel, print_casadi_vector, generate_butcher_tableu_integral, IrkSchemes
from cart_pole_with_friction import get_cart_pole_model_and_ocp
from pendulum_utils import plot_results, plot_sigma_experiment


def simulate_smoothed_model_cart_pole():
    terminal_time = 5.0
    Nsim = 100
    model, _ = get_cart_pole_model_and_ocp(F_friction=2.0, use_fillipov=False)

    # create integrator
    p_integrator = ca.vertcat(model.u, model.p)
    Phi = ca.integrator('integrator', 'idas', {
        'x': model.x,
        'ode': model.f_nonsmooth_ode,
        'p': p_integrator
    }, {'tf': terminal_time / Nsim})

    nx = casadi_length(model.x)

    # define parameters / controls
    p_traj = np.ones((casadi_length(p_integrator), Nsim))
    p_traj[0, Nsim // 2:] = -2

    xcurrent = np.zeros((nx,))
    simX = np.zeros((nx, Nsim + 1))
    simX[:, 0] = xcurrent
    # simulation loop
    for i in range(Nsim):
        out = Phi(x0=xcurrent, p=p_traj[:, i])
        xcurrent = out['xf'].full().flatten()
        simX[:, i + 1] = xcurrent

    t_grid = np.linspace(0, terminal_time, Nsim + 1)
    results = {
        'x_traj': simX.T,
        't_grid': t_grid,
        't_grid_u': t_grid,
        'u_traj': p_traj[0, :].tolist()
    }
    plot_results(results)


if __name__ == "__main__":
    simulate_smoothed_model_cart_pole()
