import numpy as np
import casadi as ca
from pendulum_utils import plot_results

import nosnoc


def get_cart_pole_model_and_ocp(F_friction: float = 2.0, use_fillipov: bool = True):
    # symbolics
    raise NotImplementedError("TODO: define states as symbolic CasADi variables using SX.sym(...)")
    # px = ...
    # theta = ...
    # v = ...
    # theta_dot = ...
    raise NotImplementedError("TODO: concatenate symbolic variables using vertcat()")
    # q = ...
    # q_dot = ...
    u = ca.SX.sym('u')  # control

    m1 = 1  # cart
    m2 = 0.1  # link
    link_length = 1
    g = 9.81
    # Inertia matrix
    raise NotImplementedError("TODO: define intertia matrix M.")
    # M = ...

    # Coriolis force
    C = ca.SX.zeros(2, 2)
    C[0, 1] = -m2 * link_length * theta_dot * ca.sin(theta)

    # all forces = Gravity + Control + Coriolis; Note: friction added later
    f_all = ca.vertcat(u, -m2 * g * link_length * ca.sin(theta)) - C @ q_dot

    x0 = np.array([1, 0 / 180 * np.pi, 0, 0])  # start downwards

    if use_fillipov:
        raise NotImplementedError('TODO: Exercise 2.5: provide pendulum model in Fillipov form')
        # Dynamics with $ v > 0$
        # f_1 =
        # Dynamics with $ v < 0$
        # f_2 =

        # F =
        # switching function (cart velocity)
        # c =
        # Sign matrix # f_1 for c=v>0, f_2 for c=v<0
        # S =
        # model = nosnoc.NosnocModel(x=x, F=F, S=S, c=c, x0=x0, u=u)
    else:
        # ODE model for Exercise 1
        sigma = ca.SX.sym('sigma')
        f_ode = ca.vertcat(q_dot,
                           ca.inv(M) @ (f_all)) # ... TODO: add friction term here later
        model = nosnoc.NosnocAutoModel(x=x, f_nonsmooth_ode=f_ode, x0=x0, u=u, p=sigma)

    ## OCP description
    # TODO Exercise 1.2
    ocp = nosnoc.NosnocOcp()
    # ocp = nosnoc.NosnocOcp(lbu=lbu, ubu=ubu, f_q=f_q, f_terminal=f_terminal, lbx=lbx, ubx=ubx)
    return model, ocp
