function model = plot_disc(results, problem_options, r1, r2, q_target1, q_target2, animation_file)
    p1 = results.x(1,:);
    p2 = results.x(2,:);
    p3 = results.x(3,:);
    p4 = results.x(4,:);
    v1 = results.x(5,:);
    v2 = results.x(6,:);
    v3 = results.x(7,:);
    v4 = results.x(8,:);
    t_opt = results.x(9,:);

    theta1 = results.z(1,:);
    theta2 = results.z(2,:);
    
    %% animation
    figure('Renderer', 'painters', 'Position', [100 100 1000 800])
    x_min = min([p1,p2,p3,p4])-1;
    x_max = max([p1,p2,p3,p4])+1;

    tt = linspace(0,2*pi,100);
    x_t = cos(tt);
    y_t = sin(tt);

    for ii = 1:length(p1)
        plot(r1*x_t+p1(ii),r1*y_t+p2(ii),'k-','LineWidth',2);
        hold on
        plot(r2*x_t+p3(ii),r2*y_t+p4(ii),'r-','LineWidth',2);
        plot(r1*x_t+q_target1(1),r1*y_t+q_target1(2),'color',[0 0 0 0.6]);
        plot(r2*x_t+q_target2(1),r2*y_t+q_target2(2),'color',[1 0 0 0.6]);
        axis equal
        xlim([x_min x_max])
        ylim([x_min x_max])
        xlabel('$x$ [m]','Interpreter','latex');
        ylabel('$y$ [m]','Interpreter','latex');

        % save gif
        frame = getframe(1);
        im = frame2im(frame);
        [imind,cm] = rgb2ind(im,256);
        if ii == 1;
            imwrite(imind,cm,animation_file,'gif', 'Loopcount',inf,'DelayTime',problem_options.h_k(1));
        else
            imwrite(imind,cm,animation_file,'gif','WriteMode','append','DelayTime',problem_options.h_k(1));
        end

        if ii~=length(p1)
            clf;
        end
    end

    %%

    figure
    subplot(311)
    plot(t_opt,v1,'LineWidth',1.5);
    hold on
    plot(t_opt,v2,'LineWidth',1.5);
    legend({'$v_1(t)$','$v_2(t)$'},'interpreter','latex');
    xlabel('$t$','interpreter','latex');
    ylabel('$v(t)$','interpreter','latex');
    grid on
    % axis equal
    subplot(312)
    plot(t_opt,v3,'LineWidth',1.5);
    hold on
    plot(t_opt,v4,'LineWidth',1.5);
    grid on
    legend({'$v_3(t)$','$v_4(t)$'},'interpreter','latex');
    xlabel('$t$','interpreter','latex');
    ylabel('$v(t)$','interpreter','latex');
    subplot(313)
    stairs(t_opt(1:3:end),[results.u,nan*ones(2,1)]','LineWidth',1.5);
    legend({'$u_1(t)$','$u_2(t)$'},'interpreter','latex');
    grid on
    xlabel('$t$','interpreter','latex');
    ylabel('$u$','interpreter','latex');

    figure
    hold on
    plot(results.t_grid(2:end), theta1, 'DisplayName', '$\theta_1(\tau)$')
    plot(results.t_grid(2:end), theta2, 'DisplayName', '$\theta_2(\tau)$')
    xlabel('$\tau$','interpreter','latex');
    ylabel('$\theta(\tau)$','interpreter','latex');
    hold off
    legend('interpreter','latex');
    grid on
    
    
end
