function [f] = hc_obj(x, param)

% Implements the nonlinear hanging chain objective
% Note that only intermediate mass points have degree of freedom

% We assume that x =
%  [y1, z1, y2, z2 ..., yN, zN].'

N = size(x, 1)/2;
y = x(1:2:2*N);
z = x(2:2:2*N);

L   = param.L;
D   = param.D;
m   = param.m;
g   = param.g;
LoN = L / (N+1); % (N+2-1) since total number of masses is N+2

xi = param.xi;
xf = param.xf;

% Initialize the potential
f = 0;
% Iterate on the points and update the potential
for k = 1 : N - 1
   f = f + 0.5 * D * (sqrt( ( y(k+1) - y(k) ).^2 + ( z(k+1) - z(k) ).^2 ) - LoN)^2 + m * g * z(k);
end
% Add the last gravitational energy
f = f + z(end) * m * g;

% Adding potential of fixed points (we have an unconstrained problem)
f = f + 0.5 * D * sum(sqrt( ( xi(1) - y(1) ).^2   + ( xi(2) - z(1) ).^2   ) - LoN)^2;
f = f + 0.5 * D * sum(sqrt( ( xf(1) - y(end) ).^2 + ( xf(2) - z(end) ).^2 ) - LoN)^2;

end
