% Hanging chain problem with BFGS and backtracking
clear; close all; clc;

plotFigures = true;

N     = 40;         % Number of (free) mass points       
tol   = 1E-3;       % comvergence tolerance     
maxit = 5000;       % maximum number of iterations

% Definining constants in a structure
param.L = 1;
param.D = (70/40)*N;
param.m = 4/N;
param.g = 9.81;
param.N = N;

% Chain end points
param.xi = [-2 1];          % initial (y1, z1)
param.xf = [ 2 1];          % final   (yN, zN)

% Initial guess: linear interpolation between the tips
y = linspace(param.xi(1), param.xf(1), N+2)';
z = linspace(param.xi(2), param.xf(2), N+2)';
% Eliminate the tips from the decision variables and stack them together
x = reshape([y(2:end-1) z(2:end-1)].',2*N,1);

% Initial Hessian approximation
B = eye(length(x));

% Get the objective value and the gradient at initial point
% TODO: WRITE YOUR FUNCTION FINITE_DIFFERENCE 
[F, J] = finite_difference(@hc_obj, x, param);

% A check whether the function you wrote is  correct
if F > 46.93 || F < 46.92 || norm(J) > 6.21 || norm(J) < 6.20  
    error('The outputs from your function finite_difference.m for the given initial point are not correct.')
end

% Printing header: iterate number, gradient norm, objective value, step norm, stepsize
fprintf('It.  \t | ||grad_f||| f\t\t | ||dvar||\t | t  \n');

% Main loop
for k = 1 : maxit
    
    % TODO: OBTAIN SEARCH DIRECTION dx USING CURRENT 'B' and 'J'
    dx = ...;
    
    % Parameters for backtracking with Armijo's condition
    t     = 1.0;    % initial step length
    beta  = 0.8;    % shrinking factor
    gamma = 0.1;    % minimal decrease requirement

    x_new = x + t * dx; % candidate for the next step

    % TODO: IMPLEMENT YOUR BACKTRACKING WITH ARMIJO'S CONDITION HERE
    %       (KEEP SHRINKING 't' AND UPDATING 'x_new' UNTIL CONDITION IS SATISFIED)


  
    % Assign the step
    [F_new, J_new] = finite_difference(@hc_obj, x_new, param);
    
    
    % TODO: UPDATE YOUR HESSIAN APPROXIMATION 'B' USING THE BFGS FORMULA HERE (FOR QUESTION 2c ONLY)
    
    
    % Update variables
    x = x_new;
    J = J_new;
    F = F_new;

    % Every 10 iterations print the header again
    if mod(k,10) == 0
        fprintf('\n');
        fprintf('It.  \t | ||grad_f||| f\t\t | ||dvar||\t | t  \n');
    end
    
    % Print some useful information
    fprintf('%d\t | %f\t | %f\t | %f\t | %f \n', k, norm(J), F, norm(dx), t);
    
    % plotting
    if plotFigures
        y = x(1:2:2*N);
        z = x(2:2:2*N);
        % Plotting 
        figure(1)
        subplot(2,1,1), plot(y, z,'b--');hold on;
        subplot(2,1,1), plot(y, z, 'Or'); hold off;
        xlim([-2, 2])
        ylim([ -3, 1])
        title('Position of chain at current iterate')
        subplot(2,1,2), plot(dx)
        title('full step of each optimization variable (dz_i)')
        drawnow;
    end
    if norm(J) < tol
        disp('Convergence achieved.');
        break
    end
end
if k == maxit
    disp('Maximum iterations reached. Result probably not optimal.')
end

% Plot optimal solution 
figure(1)
y = x(1:2:2*N);
z = x(2:2:2*N);
subplot(2,1,1), plot(y, z, 'b--');hold on;
title('Position of chain at optimal solution')
subplot(2,1,1), plot(y, z, 'Or'); hold off;
xlim([-2, 2])
ylim([ -3, 1])
