clc;
clear;
close all;

%% plot the objective function

% define the function as anonymous function handle
% you can then evaluate it as f(x,y) (elementwise)
f = @(x,y) .5*( (x-1).^2 + 100*(y-x.^2).^2 + y.^2);

% Create circle grid of x y values 
R = 0:.002:sqrt(2);
TH = 2*pi*(0:.002:1); 
X = R'*cos(TH); 
Y = R'*sin(TH);

% calculate objective function values
% add 1 and take log for better visualization
Z = log( 1 + f(X,Y));

figure(1); clf;
colormap('gray');

% subplot 1 with surface plot and contour plot
subplot(1,2,1); hold on
view([124 34]);
grid('on'); axis square;
surf(X,Y,Z,'LineStyle','none');
contour(X,Y,Z);
xlabel('x')
ylabel('y')
zlabel('log(1+f(x,y))')
title('surface plot of objective function')

% subplot 2 with contour plot only
subplot(1,2,2); hold on
grid('on'); axis square;
contour(X,Y,Z);
xlabel('x')
ylabel('y')
title('contour plot of objective function')
% read current axis limits and fix them at these values
ax = axis(); axis(ax);

%% derivatives
% TODO: write the functions of gradient, hessian (and hessian
% approximations) here (as derived on paper)

fgrad = @(x,y) [      ;
                      ];

fhess = @(x,y)[   ,   ;
                  ,   ];

...

%% Implementation

% TODO: your implementation of the Newton Type methods



%% results
figure(1); subplot(1,2,2);
% you can add the plot of the iteration trajectory (xk,yk) here

